/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import zabi.minecraft.extraalchemy.ExtraAlchemy;
import zabi.minecraft.extraalchemy.client.tooltip.StatusEffectContainer;
import zabi.minecraft.extraalchemy.config.ModConfig;
import zabi.minecraft.extraalchemy.items.ModComponents;
import zabi.minecraft.extraalchemy.statuseffect.ToggleableEffect;

public class PotionRingItem
extends class_1792
implements StatusEffectContainer {
    public PotionRingItem() {
        super(new class_1792.class_1793().method_7889(1).method_57349(ModComponents.DISABLED, (Object)false));
    }

    public boolean method_7886(class_1799 stack) {
        return (Boolean)stack.method_57353().method_57829(ModComponents.DISABLED) == false;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        try {
            boolean disabled;
            PotionRingData prd = (PotionRingData)stack.method_57825(ModComponents.POTION_RING_DATA, (Object)PotionRingData.EMPTY);
            if (prd.effect().isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43470((String)"Error: rings must have an effect attached!").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}));
                return;
            }
            class_1291 effect = prd.effect().get();
            class_5250 potionName = class_2561.method_43471((String)effect.method_5567()).method_27692(class_124.field_1064);
            class_5250 potionLevel = class_2561.method_43471((String)("potion.potency." + prd.level)).method_27692(class_124.field_1064);
            tooltip.add((class_2561)class_2561.method_43469((String)"item.extraalchemy.potion_ring.potion", (Object[])new Object[]{potionName, potionLevel}));
            int cost = prd.cost;
            if (cost > 0) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.extraalchemy.potion_ring.cost", (Object[])new Object[]{class_2561.method_43470((String)("" + cost)).method_27692(class_124.field_1065)}));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.extraalchemy.potion_ring.creative").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}));
            }
            int length = prd.duration;
            tooltip.add((class_2561)class_2561.method_43469((String)"item.extraalchemy.potion_ring.length", (Object[])new Object[]{class_2561.method_43470((String)("" + length)).method_27692(class_124.field_1078)}));
            boolean bl = disabled = stack.method_57353().method_57832(ModComponents.DISABLED) && (Boolean)stack.method_57353().method_57829(ModComponents.DISABLED) != false;
            if (disabled) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.extraalchemy.potion_ring.disabled").method_27692(class_124.field_1065));
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.extraalchemy.potion_ring.enabled").method_27692(class_124.field_1060));
            }
        }
        catch (Exception e) {
            tooltip.add((class_2561)class_2561.method_43470((String)"An error occurred when displaying the tooltip.").method_27692(class_124.field_1061));
            tooltip.add((class_2561)class_2561.method_43470((String)"Destroy this item ASAP to avoid crashes.").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
            tooltip.add((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1063));
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user.method_5715()) {
            PotionRingItem.toggleRingStack(stack);
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        return new class_1271(class_1269.field_5814, (Object)stack);
    }

    public static class_1799 toggleRingStack(class_1799 stack) {
        boolean disabled = (Boolean)stack.method_57825(ModComponents.DISABLED, (Object)true);
        stack.method_57379(ModComponents.DISABLED, (Object)(!disabled ? 1 : 0));
        return stack;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!ExtraAlchemy.areRingModsInstalled() || ModConfig.INSTANCE.allowRingsInInventoryWithThirdPartyMods) {
            PotionRingItem.onTick(stack, entity);
        }
    }

    public static void onTick(class_1799 stack, class_1297 entity) {
        boolean disabled = (Boolean)stack.method_57825(ModComponents.DISABLED, (Object)true);
        if (!disabled && entity instanceof class_1309) {
            class_1309 e = (class_1309)entity;
            PotionRingData prd = (PotionRingData)stack.method_57825(ModComponents.POTION_RING_DATA, (Object)PotionRingData.EMPTY);
            if (prd.effect().isEmpty()) {
                return;
            }
            class_6880 entry = class_7923.field_41174.method_47983((Object)prd.effect().get());
            class_1293 onEntity = e.method_6112(entry);
            int cost = prd.cost;
            if ((onEntity == null || onEntity.method_5584() <= prd.renewalTime * 20) && PotionRingItem.drainXP(e, cost, prd.effect().get())) {
                int length = prd.duration;
                e.method_6092(new class_1293(entry, length * 20, prd.level(), false, false, true));
            }
        }
    }

    private static boolean drainXP(class_1309 e, int cost, class_1291 effect) {
        ToggleableEffect te;
        if (cost <= 0) {
            return true;
        }
        if (effect instanceof ToggleableEffect && !(te = (ToggleableEffect)effect).isActive(e)) {
            return false;
        }
        if (e instanceof class_1657) {
            class_1657 p = (class_1657)e;
            if (p.method_7337()) {
                return true;
            }
            if (p.field_7495 < cost && p.field_7520 == 0) {
                return false;
            }
            p.method_7255(-cost);
        }
        return true;
    }

    @Override
    public List<class_1293> getContainedEffects(class_1799 stack) {
        PotionRingData prd = (PotionRingData)stack.method_57825(ModComponents.POTION_RING_DATA, (Object)PotionRingData.EMPTY);
        Optional<class_1291> eff = prd.effect();
        if (eff.isEmpty()) {
            return Collections.emptyList();
        }
        class_6880 rse = class_7923.field_41174.method_47983((Object)eff.get());
        return List.of(new class_1293(rse, 0, prd.level()));
    }

    public record PotionRingData(Optional<class_1291> effect, int level, int cost, int duration, int renewalTime) {
        public static final PotionRingData EMPTY = new PotionRingData(Optional.empty(), 0, 0, 0, 0);
        public static final Codec<PotionRingData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41174.method_39673().optionalFieldOf("effect").forGetter(PotionRingData::effect), (App)Codec.INT.fieldOf("level").forGetter(PotionRingData::level), (App)Codec.INT.fieldOf("cost").forGetter(PotionRingData::cost), (App)Codec.INT.fieldOf("duration").forGetter(PotionRingData::duration), (App)Codec.INT.fieldOf("renewalTime").forGetter(PotionRingData::renewalTime)).apply((Applicative)instance, PotionRingData::new));
    }
}

